/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.capture.saving.ExposureUploader;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import io.github.mortuusars.exposure.client.image.modifier.ImageModifier;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.util.cycles.task.EmptyTask;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureProperties;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import net.minecraft.class_1297;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class SingleChannelCaptureTemplate
implements CaptureTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Task<?> createTask(CaptureProperties data) {
        if (data.exposureId().isEmpty()) {
            LOGGER.error("Failed to create capture task: exposure id cannot be empty. '{}'", (Object)data);
            return new EmptyTask();
        }
        int entityId = data.cameraHolderEntityId().orElse(Minecrft.player().method_5628());
        class_1297 class_12972 = Minecrft.level().method_8469(entityId);
        if (!(class_12972 instanceof CameraHolder)) {
            LOGGER.error("Failed to create capture task: camera holder cannot be obtained. '{}'", (Object)data);
            return new EmptyTask();
        }
        CameraHolder cameraHolder = (CameraHolder)class_12972;
        class_1297 entity = cameraHolder.asHolderEntity();
        ExposureType filmType = data.filmType();
        int frameSize = data.frameSize().orElse(Config.Server.DEFAULT_FRAME_SIZE.getAsInt());
        class_6880<ColorPalette> palette = data.getColorPalette(Minecrft.registryAccess());
        return Capture.of(Capture.screenshot(), CaptureAction.setCameraEntity(entity), CaptureAction.hideGui(), CaptureAction.forceRegularOrSelfieCamera(), CaptureAction.optional(data.singleChannel(), channel -> CaptureAction.setPostEffect(channel.getShader())), CaptureAction.modifyGamma(data.getShutterSpeed()), CaptureAction.optional(data.flash(), () -> CaptureAction.flash(entity))).handleErrorAndGetResult(this.printCasualErrorInChat()).then(ImageModifier.chain(ImageModifier.Crop.SQUARE_CENTER, ImageModifier.Crop.factor(data.cropFactor()), ImageModifier.Resize.to(frameSize), ImageModifier.brightness(data.getShutterSpeed()), ImageModifier.optional(filmType == ExposureType.BLACK_AND_WHITE, data.singleChannel().map(ImageModifier::singleChannelBlackAndWhite).orElse(ImageModifier.BLACK_AND_WHITE)))).thenAsync(Palettizer.DITHERED.palettizeAndClose((ColorPalette)palette.comp_349())).then(this.convertToExposureData(palette, this.createExposureTag(cameraHolder.getPlayerExecutingExposure(), data, false))).accept(image -> ExposureUploader.upload(data.exposureId(), image)).onError(this.printCasualErrorInChat());
    }
}

